<?php
/* --------------------------------------------------------------
 ConfigurationDataLoader.php 2020-02-20
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2020 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 --------------------------------------------------------------
 */

declare(strict_types=1);

namespace Gambio\Admin\Layout\Smarty\Loaders;

use Gambio\Core\Application\ValueObjects\Url;
use Gambio\Core\Configuration\ConfigurationService;
use Smarty;

/**
 * Class ConfigurationDataLoader
 * @package Gambio\Admin\Layout\Smarty\Loaders
 */
class ConfigurationDataLoader implements LoaderInterface
{
    /**
     * @var ConfigurationService
     */
    private $configurationService;
    
    /**
     * @var Url
     */
    private $url;
    
    
    /**
     * ConfigurationDataLoader constructor.
     *
     * @param ConfigurationService $configurationService
     * @param Url                  $url
     */
    public function __construct(ConfigurationService $configurationService, Url $url)
    {
        $this->configurationService = $configurationService;
        $this->url                  = $url;
    }
    
    
    /**
     * Loads configuration data and assigned it to smarty.
     *
     * @param Smarty $smarty
     */
    public function load(Smarty $smarty): void
    {
        $offlineConfig = $this->configurationService->find('gm_configuration/GM_SHOP_OFFLINE');
        $shopOffline   = $offlineConfig ? $offlineConfig->value() === 'checked' : false;
        $smarty->assign('shop_offline', $shopOffline);
        
        $shopKeyConfig = $this->configurationService->find('gm_configuration/SHOP_KEY_VALID');
        $shopKeyValid  = $shopKeyConfig ? (strtolower($shopKeyConfig->value()) === 'true'
                                           || $shopKeyConfig->value() === '0') : false;
        $smarty->assign('shop_key_state', $shopKeyValid);
        
        $installedVersion = $this->configurationService->find('gm_configuration/INSTALLED_VERSION');
        $smarty->assign('shop_version', $installedVersion->value());
        
        $smarty->assign('base_url', $this->url->base());
    }
}